unit Ap_testm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Alphabar, DB, DBTables, Grids,
  DBGrids, Menus;

type
  TMainform = class(TForm)
    EmployeeTable: TTable;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    EmployeeTableLastName: TStringField;
    EmployeeTableFirstName: TStringField;
    EmployeeTableSalary: TFloatField;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    SymbolEdit: TEdit;
    SymbolPanel: TAlphaPanel;
    AlphaPanel: TAlphaPanel;
    PopupMenu1: TPopupMenu;
    pomIndexPanel: TMenuItem;
    pomFilterPanel: TMenuItem;
    GroupBox1: TGroupBox;
    PanelKindPanel: TAlphaPanel;
    procedure PanelKindChanged(Sender: TObject);
    procedure AlphaPanelValueChange(Sender: TObject);
    procedure pomIndexPanelClick(Sender: TObject);
    procedure pomFilterPanelClick(Sender: TObject);
    procedure SymbolPanelValueChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Mainform: TMainform;

implementation

{$R *.DFM}

procedure TMainform.PanelKindChanged(Sender: TObject);
begin
  if PanelKindPanel.Value = 'Index panel' then
  begin {** Index panel }
    EmployeeTable.CancelRange;
    AlphaPanel.CatchButtons := false;
    AlphaPanel.Hint := 'click to move the table cursor';
  end else
  begin {** Filter panel }
    AlphaPanel.CatchButtons := true;
    AlphaPanel.Value := EmptyStr;
    AlphaPanel.Hint := 'click to activate/deactivate a filter';
  end;
end;

procedure TMainform.AlphaPanelValueChange(Sender: TObject);
var
  aChar : char;
begin
  if PanelKindPanel.Value = 'Index panel' then
  begin {** Index panel }
    EmployeeTable.FindNearest([AlphaPanel.Value]);
  end else
  begin {** Filter panel } 
    if AlphaPanel.Value = EmptyStr then
    begin
      EmployeeTable.CancelRange;
      EmployeeTable.First;
    end
    else
      with EmployeeTable do
      begin
        aChar := AlphaPanel.Value[1];
        EditRangeStart;
        FieldByName('LastName').AsString := AlphaPanel.Value;
        EditRangeEnd;
        FieldByName('LastName').AsString := chr(ord(aChar) + 1);
        ApplyRange;
      end;
  end;
end;

procedure TMainform.pomIndexPanelClick(Sender: TObject);
begin
  pomIndexPanel.Checked := true;
  pomFilterPanel.Checked := false;
  PanelKindPanel.Value := 'Index panel';
end;

procedure TMainform.pomFilterPanelClick(Sender: TObject);
begin
  pomIndexPanel.Checked := false;
  pomFilterPanel.Checked := true;
  PanelKindPanel.Value := 'Filter panel';
end;

procedure TMainform.SymbolPanelValueChange(Sender: TObject);
begin
  SymbolEdit.Text := SymbolEdit.Text + SymbolPanel.Value;
end;

procedure TMainform.FormCreate(Sender: TObject);
begin
  PanelKindPanel.Value := 'Index panel';
end;

end.
